@REM $Id: pop2imap_example.bat,v 1.2 2020/12/23 19:18:28 gilles Exp gilles $

@REM pop2imap example batch for Windows users
@REM lines beginning with @REM are just comments 
@REM Please read them, they are written for you, human folk.

@REM Read also http://linux-france.org/prj/pop2imap/README_Windows.txt
@REM for more details on how to use pop2imap on Windows.

@REM Now let us enter the real work to fit your needs
@REM Replace below the 6 parameters  
@REM "test1.lamiral.info"  "test1"  "secret1"  "test2.lamiral.info"  "test2"  "secret2"
@REM with your own values
@REM Double quotes are necessary if a value contain one or more blanks.

@REM value "test1.lamiral.info" for --host1     is the POP3 source server hostname or IP address
@REM value "test1"              for --user1     is the POP3 source user login
@REM value "secret1"            for --password1 is the POP3 source user password

@REM value "test2.lamiral.info" for --host2 is the IMAP destination server hostname or IP address
@REM value "test2"              for --user2 is the IMAP destination user login
@REM value "secret2"            for --password2 is the IMAP destination user password

@REM Character ^ at the end of the first line is essential and means
@REM "this command continues on the next line". You can add other lines
@REM but don't forget ^ character lasting each line, except the last one.

@REM That is not all, keep on reading!

@REM Three other options are in this example because they are good to start with
@REM
@REM --dry makes pop2imap doing nothing, just print what would be done without --dry.
@REM so if you leave --dry then pop2imap will not sync your data.

@REM In case you are impatient, just remove --dry 
@REM in the firt place and go. pop2imap is not that bad by default anyway!


@SETLOCAL
@ECHO OFF

ECHO Currently running through %0 %*

@REM going in the directory where pop2imap binary is
CD /D %~dp0


.\pop2imap.exe --host1 "test1.lamiral.info"  --user1 "test1" --password1  "secret1"  ^
               --host2 "test2.lamiral.info"  --user2 "test2" --password2  "secret2"  --dry 

@ECHO The sync is over.
@ECHO Hit any key to close this window
@ECHO the following word "to continue" means in fact "to close this window" 
@PAUSE

